/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.tr7zw.firstperson.MinecraftWrapper;
import dev.tr7zw.firstperson.api.ActivationHandler;
import dev.tr7zw.firstperson.api.FirstPersonAPI;
import dev.tr7zw.firstperson.config.CustomConfigScreen;
import dev.tr7zw.firstperson.config.FirstPersonSettings;
import dev.tr7zw.firstperson.modsupport.PlayerAnimatorSupport;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_7172;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FirstPersonModelCore {
    public static final Logger LOGGER = LogManager.getLogger((String)"FirstPersonModel");
    public static MinecraftWrapper wrapper;
    public static FirstPersonModelCore instance;
    public static boolean isRenderingPlayer;
    public static boolean enabled;
    public static FirstPersonSettings config;
    protected static boolean isHeld;
    public static class_304 keyBinding;
    private File settingsFile = new File("config", "firstperson.json");
    private boolean lateInit = true;
    public static final float sneakBodyOffset = 0.27f;
    public static final float swimUpBodyOffset = 0.6f;
    public static final float swimDownBodyOffset = 0.5f;
    public static final float inVehicleBodyOffset = 0.2f;

    public void sharedSetup() {
        LOGGER.info("Loading FirstPerson Mod");
        wrapper = new MinecraftWrapper(class_310.method_1551());
        if (this.settingsFile.exists()) {
            try {
                config = (FirstPersonSettings)new Gson().fromJson(new String(Files.readAllBytes(this.settingsFile.toPath()), StandardCharsets.UTF_8), FirstPersonSettings.class);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (config == null) {
            config = new FirstPersonSettings();
        }
        this.writeSettings();
        enabled = FirstPersonModelCore.config.enabledByDefault;
        this.registerKeybinds();
    }

    public abstract void registerKeybinds();

    public static MinecraftWrapper getWrapper() {
        return wrapper;
    }

    public static boolean fixBodyShadow(class_4587 matrixStack) {
        return enabled && (FirstPersonModelCore.config.forceActive || isRenderingPlayer);
    }

    private void lateInit() {
        try {
            if (FirstPersonModelCore.isValidClass("dev.kosmx.playerAnim.core.impl.AnimationProcessor")) {
                LOGGER.info("Loading PlayerAnimator support!");
                FirstPersonAPI.registerPlayerHandler(new PlayerAnimatorSupport());
            } else {
                LOGGER.info("PlayerAnimator not found!");
            }
        }
        catch (Throwable ex) {
            LOGGER.warn("Error during initialization of mod support.", ex);
        }
        FirstPersonAPI.registerPlayerHandler(new ActivationHandler(){

            @Override
            public boolean preventFirstperson() {
                return class_310.method_1551().field_1724.method_31550();
            }
        });
    }

    public void onTick() {
        if (this.lateInit) {
            this.lateInit = false;
            this.lateInit();
        }
        if (keyBinding.method_1434()) {
            if (isHeld) {
                return;
            }
            isHeld = true;
            enabled = !enabled;
        } else {
            isHeld = false;
        }
    }

    public void writeSettings() {
        String json = new GsonBuilder().setPrettyPrinting().create().toJson((Object)config);
        try {
            Files.write(this.settingsFile.toPath(), json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class_437 createConfigScreen(class_437 parent) {
        CustomConfigScreen screen = new CustomConfigScreen(parent, "text.firstperson.title"){

            @Override
            public void initialize() {
                this.getOptions().method_20406(this.getOnOffOption("text.firstperson.option.firstperson.enabledByDefault", () -> FirstPersonModelCore.config.enabledByDefault, b -> {
                    FirstPersonModelCore.config.enabledByDefault = b;
                }));
                ArrayList<Object> options = new ArrayList<Object>();
                options.add(this.getIntOption("text.firstperson.option.firstperson.xOffset", -40, 40, () -> FirstPersonModelCore.config.xOffset, i -> {
                    FirstPersonModelCore.config.xOffset = i;
                }));
                options.add(this.getIntOption("text.firstperson.option.firstperson.sneakXOffset", -40, 40, () -> FirstPersonModelCore.config.sneakXOffset, i -> {
                    FirstPersonModelCore.config.sneakXOffset = i;
                }));
                options.add(this.getIntOption("text.firstperson.option.firstperson.sitXOffset", -40, 40, () -> FirstPersonModelCore.config.sitXOffset, i -> {
                    FirstPersonModelCore.config.sitXOffset = i;
                }));
                options.add(this.getOnOffOption("text.firstperson.option.firstperson.renderStuckFeatures", () -> FirstPersonModelCore.config.renderStuckFeatures, b -> {
                    FirstPersonModelCore.config.renderStuckFeatures = b;
                }));
                options.add(this.getOnOffOption("text.firstperson.option.firstperson.vanillaHands", () -> FirstPersonModelCore.config.vanillaHands, b -> {
                    FirstPersonModelCore.config.vanillaHands = b;
                }));
                options.add(this.getOnOffOption("text.firstperson.option.firstperson.doubleHands", () -> FirstPersonModelCore.config.doubleHands, b -> {
                    FirstPersonModelCore.config.doubleHands = b;
                }));
                options.add(this.getOnOffOption("text.firstperson.option.firstperson.forceActive", () -> FirstPersonModelCore.config.forceActive, b -> {
                    FirstPersonModelCore.config.forceActive = b;
                }));
                this.getOptions().method_20408(options.toArray(new class_7172[0]));
            }

            @Override
            public void save() {
                FirstPersonModelCore.this.writeSettings();
            }

            @Override
            public void reset() {
                config = new FirstPersonSettings();
                FirstPersonModelCore.this.writeSettings();
            }
        };
        return screen;
    }

    protected static boolean isValidClass(String name) {
        try {
            if (Class.forName(name) != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    static {
        isRenderingPlayer = false;
        enabled = true;
        config = null;
        isHeld = false;
        keyBinding = new class_304("key.firstperson.toggle", 295, "Firstperson");
    }
}

